'use strict';

/* --------------------------------------------------------------
 viewport.js 2016-06-14
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx.controllers.module('viewport', [], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    /**
     * Info Row
     *
     * @type {jQuery}
     */
    var $infoRow = $('#main-footer .info.row');

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * Checks if the provided dropdown is out of the vertical viewport.
     *
     * @param {jQuery} $dropDownMenu
     *
     * @returns {boolean}
     */
    function _isDropDownOutOfVerticalView($dropDownMenu) {
        var infoRowTopPosition = $infoRow.offset().top;
        var dropDownMenuTopPosition = $dropDownMenu.height() + $dropDownMenu.siblings('.dropdown-toggle').offset().top;

        return dropDownMenuTopPosition > infoRowTopPosition;
    }

    /**
     * Checks if the provided dropdown is out of the horizontal viewport.
     *
     * @param {jQuery} $dropDownMenu
     *
     * @returns {boolean}
     */
    function _isDropDownOutOfHorizontalView($dropDownMenu) {
        var viewportWidth = $('body').width();
        var dropDownMenuLeftPosition = $dropDownMenu.width() + $dropDownMenu.siblings('.dropdown-toggle').prev().offset().left;

        return dropDownMenuLeftPosition > viewportWidth;
    }

    /**
     * Adjust the dropdown position, depending on the current viewport.
     */
    function _adjustDropDownPosition() {

        var $target = $(this);

        var $dropDownMenu = $target.find('.dropdown-menu');

        // Put the dropdown menu above the clicked target,
        // if the menu would touch or even be larger than the info row in the main footer.
        if (_isDropDownOutOfVerticalView($dropDownMenu)) {
            $target.addClass('dropup');
            $target.removeClass('dropdown');
            $target.find('.caret').addClass('caret-reversed');
        } else if ($target.hasClass('dropup')) {
            $target.removeClass('dropup');
            $target.addClass('dropdown');
            $target.find('.caret').removeClass('caret-reversed');
        }

        if (_isDropDownOutOfHorizontalView($dropDownMenu)) {
            $dropDownMenu.addClass('dropdown-menu-right');
        } else if ($target.hasClass('dropdown-menu-right')) {
            $target.removeClass('dropdown-menu-right');
        }
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $('body').on('show.bs.dropdown', '.btn-group.dropdown, .btn-group.dropup', _adjustDropDownPosition);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxheW91dHMvbWFpbi92aWV3cG9ydC5qcyJdLCJuYW1lcyI6WyJneCIsImNvbnRyb2xsZXJzIiwibW9kdWxlIiwiZGF0YSIsIiR0aGlzIiwiJCIsIiRpbmZvUm93IiwiX2lzRHJvcERvd25PdXRPZlZlcnRpY2FsVmlldyIsIiRkcm9wRG93bk1lbnUiLCJpbmZvUm93VG9wUG9zaXRpb24iLCJvZmZzZXQiLCJ0b3AiLCJkcm9wRG93bk1lbnVUb3BQb3NpdGlvbiIsImhlaWdodCIsInNpYmxpbmdzIiwiX2lzRHJvcERvd25PdXRPZkhvcml6b250YWxWaWV3Iiwidmlld3BvcnRXaWR0aCIsIndpZHRoIiwiZHJvcERvd25NZW51TGVmdFBvc2l0aW9uIiwicHJldiIsImxlZnQiLCJfYWRqdXN0RHJvcERvd25Qb3NpdGlvbiIsIiR0YXJnZXQiLCJmaW5kIiwiYWRkQ2xhc3MiLCJyZW1vdmVDbGFzcyIsImhhc0NsYXNzIiwiaW5pdCIsImRvbmUiLCJvbiJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7Ozs7OztBQVVBQSxHQUFHQyxXQUFILENBQWVDLE1BQWYsQ0FBc0IsVUFBdEIsRUFBa0MsRUFBbEMsRUFBc0MsVUFBVUMsSUFBVixFQUFnQjs7QUFFbEQ7O0FBRUE7QUFDQTtBQUNBOztBQUVBOzs7Ozs7QUFLQSxRQUFNQyxRQUFRQyxFQUFFLElBQUYsQ0FBZDs7QUFFQTs7Ozs7QUFLQSxRQUFNSCxTQUFTLEVBQWY7O0FBRUE7Ozs7O0FBS0EsUUFBTUksV0FBV0QsRUFBRSx3QkFBRixDQUFqQjs7QUFHQTtBQUNBO0FBQ0E7O0FBRUE7Ozs7Ozs7QUFPQSxhQUFTRSw0QkFBVCxDQUFzQ0MsYUFBdEMsRUFBcUQ7QUFDakQsWUFBTUMscUJBQXFCSCxTQUFTSSxNQUFULEdBQWtCQyxHQUE3QztBQUNBLFlBQU1DLDBCQUEwQkosY0FBY0ssTUFBZCxLQUF5QkwsY0FBY00sUUFBZCxDQUF1QixrQkFBdkIsRUFBMkNKLE1BQTNDLEdBQW9EQyxHQUE3Rzs7QUFFQSxlQUFPQywwQkFBMEJILGtCQUFqQztBQUNIOztBQUVEOzs7Ozs7O0FBT0EsYUFBU00sOEJBQVQsQ0FBd0NQLGFBQXhDLEVBQXVEO0FBQ25ELFlBQU1RLGdCQUFnQlgsRUFBRSxNQUFGLEVBQVVZLEtBQVYsRUFBdEI7QUFDQSxZQUFNQywyQkFBMkJWLGNBQWNTLEtBQWQsS0FBd0JULGNBQWNNLFFBQWQsQ0FBdUIsa0JBQXZCLEVBQ3BESyxJQURvRCxHQUVwRFQsTUFGb0QsR0FFM0NVLElBRmQ7O0FBSUEsZUFBT0YsMkJBQTJCRixhQUFsQztBQUNIOztBQUVEOzs7QUFHQSxhQUFTSyx1QkFBVCxHQUFtQzs7QUFFL0IsWUFBTUMsVUFBVWpCLEVBQUUsSUFBRixDQUFoQjs7QUFFQSxZQUFJRyxnQkFBZ0JjLFFBQVFDLElBQVIsQ0FBYSxnQkFBYixDQUFwQjs7QUFFQTtBQUNBO0FBQ0EsWUFBSWhCLDZCQUE2QkMsYUFBN0IsQ0FBSixFQUFpRDtBQUM3Q2Msb0JBQVFFLFFBQVIsQ0FBaUIsUUFBakI7QUFDQUYsb0JBQVFHLFdBQVIsQ0FBb0IsVUFBcEI7QUFDQUgsb0JBQVFDLElBQVIsQ0FBYSxRQUFiLEVBQXVCQyxRQUF2QixDQUFnQyxnQkFBaEM7QUFDSCxTQUpELE1BSU8sSUFBSUYsUUFBUUksUUFBUixDQUFpQixRQUFqQixDQUFKLEVBQWdDO0FBQ25DSixvQkFBUUcsV0FBUixDQUFvQixRQUFwQjtBQUNBSCxvQkFBUUUsUUFBUixDQUFpQixVQUFqQjtBQUNBRixvQkFBUUMsSUFBUixDQUFhLFFBQWIsRUFBdUJFLFdBQXZCLENBQW1DLGdCQUFuQztBQUNIOztBQUVELFlBQUlWLCtCQUErQlAsYUFBL0IsQ0FBSixFQUFtRDtBQUMvQ0EsMEJBQWNnQixRQUFkLENBQXVCLHFCQUF2QjtBQUNILFNBRkQsTUFFTyxJQUFJRixRQUFRSSxRQUFSLENBQWlCLHFCQUFqQixDQUFKLEVBQTZDO0FBQ2hESixvQkFBUUcsV0FBUixDQUFvQixxQkFBcEI7QUFDSDtBQUNKOztBQUVEO0FBQ0E7QUFDQTs7QUFFQXZCLFdBQU95QixJQUFQLEdBQWMsVUFBVUMsSUFBVixFQUFnQjtBQUMxQnZCLFVBQUUsTUFBRixFQUFVd0IsRUFBVixDQUFhLGtCQUFiLEVBQWlDLHdDQUFqQyxFQUEyRVIsdUJBQTNFOztBQUVBTztBQUNILEtBSkQ7O0FBTUEsV0FBTzFCLE1BQVA7QUFDSCxDQXZHRCIsImZpbGUiOiJsYXlvdXRzL21haW4vdmlld3BvcnQuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxyXG4gdmlld3BvcnQuanMgMjAxNi0wNi0xNFxyXG4gR2FtYmlvIEdtYkhcclxuIGh0dHA6Ly93d3cuZ2FtYmlvLmRlXHJcbiBDb3B5cmlnaHQgKGMpIDIwMTYgR2FtYmlvIEdtYkhcclxuIFJlbGVhc2VkIHVuZGVyIHRoZSBHTlUgR2VuZXJhbCBQdWJsaWMgTGljZW5zZSAoVmVyc2lvbiAyKVxyXG4gW2h0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy9ncGwtMi4wLmh0bWxdXHJcbiAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxyXG4gKi9cclxuXHJcbmd4LmNvbnRyb2xsZXJzLm1vZHVsZSgndmlld3BvcnQnLCBbXSwgZnVuY3Rpb24gKGRhdGEpIHtcclxuXHJcbiAgICAndXNlIHN0cmljdCc7XHJcblxyXG4gICAgLy8gLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXHJcbiAgICAvLyBWQVJJQUJMRVNcclxuICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxyXG5cclxuICAgIC8qKlxyXG4gICAgICogTW9kdWxlIFNlbGVjdG9yXHJcbiAgICAgKlxyXG4gICAgICogQHR5cGUge2pRdWVyeX1cclxuICAgICAqL1xyXG4gICAgY29uc3QgJHRoaXMgPSAkKHRoaXMpO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogTW9kdWxlIEluc3RhbmNlXHJcbiAgICAgKlxyXG4gICAgICogQHR5cGUge09iamVjdH1cclxuICAgICAqL1xyXG4gICAgY29uc3QgbW9kdWxlID0ge307XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBJbmZvIFJvd1xyXG4gICAgICpcclxuICAgICAqIEB0eXBlIHtqUXVlcnl9XHJcbiAgICAgKi9cclxuICAgIGNvbnN0ICRpbmZvUm93ID0gJCgnI21haW4tZm9vdGVyIC5pbmZvLnJvdycpO1xyXG5cclxuXHJcbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuICAgIC8vIEZVTkNUSU9OU1xyXG4gICAgLy8gLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBDaGVja3MgaWYgdGhlIHByb3ZpZGVkIGRyb3Bkb3duIGlzIG91dCBvZiB0aGUgdmVydGljYWwgdmlld3BvcnQuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtIHtqUXVlcnl9ICRkcm9wRG93bk1lbnVcclxuICAgICAqXHJcbiAgICAgKiBAcmV0dXJucyB7Ym9vbGVhbn1cclxuICAgICAqL1xyXG4gICAgZnVuY3Rpb24gX2lzRHJvcERvd25PdXRPZlZlcnRpY2FsVmlldygkZHJvcERvd25NZW51KSB7XHJcbiAgICAgICAgY29uc3QgaW5mb1Jvd1RvcFBvc2l0aW9uID0gJGluZm9Sb3cub2Zmc2V0KCkudG9wO1xyXG4gICAgICAgIGNvbnN0IGRyb3BEb3duTWVudVRvcFBvc2l0aW9uID0gJGRyb3BEb3duTWVudS5oZWlnaHQoKSArICRkcm9wRG93bk1lbnUuc2libGluZ3MoJy5kcm9wZG93bi10b2dnbGUnKS5vZmZzZXQoKS50b3BcclxuXHJcbiAgICAgICAgcmV0dXJuIGRyb3BEb3duTWVudVRvcFBvc2l0aW9uID4gaW5mb1Jvd1RvcFBvc2l0aW9uO1xyXG4gICAgfVxyXG5cclxuICAgIC8qKlxyXG4gICAgICogQ2hlY2tzIGlmIHRoZSBwcm92aWRlZCBkcm9wZG93biBpcyBvdXQgb2YgdGhlIGhvcml6b250YWwgdmlld3BvcnQuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtIHtqUXVlcnl9ICRkcm9wRG93bk1lbnVcclxuICAgICAqXHJcbiAgICAgKiBAcmV0dXJucyB7Ym9vbGVhbn1cclxuICAgICAqL1xyXG4gICAgZnVuY3Rpb24gX2lzRHJvcERvd25PdXRPZkhvcml6b250YWxWaWV3KCRkcm9wRG93bk1lbnUpIHtcclxuICAgICAgICBjb25zdCB2aWV3cG9ydFdpZHRoID0gJCgnYm9keScpLndpZHRoKCk7XHJcbiAgICAgICAgY29uc3QgZHJvcERvd25NZW51TGVmdFBvc2l0aW9uID0gJGRyb3BEb3duTWVudS53aWR0aCgpICsgJGRyb3BEb3duTWVudS5zaWJsaW5ncygnLmRyb3Bkb3duLXRvZ2dsZScpXHJcbiAgICAgICAgICAgIC5wcmV2KClcclxuICAgICAgICAgICAgLm9mZnNldCgpLmxlZnQ7XHJcblxyXG4gICAgICAgIHJldHVybiBkcm9wRG93bk1lbnVMZWZ0UG9zaXRpb24gPiB2aWV3cG9ydFdpZHRoO1xyXG4gICAgfVxyXG5cclxuICAgIC8qKlxyXG4gICAgICogQWRqdXN0IHRoZSBkcm9wZG93biBwb3NpdGlvbiwgZGVwZW5kaW5nIG9uIHRoZSBjdXJyZW50IHZpZXdwb3J0LlxyXG4gICAgICovXHJcbiAgICBmdW5jdGlvbiBfYWRqdXN0RHJvcERvd25Qb3NpdGlvbigpIHtcclxuXHJcbiAgICAgICAgY29uc3QgJHRhcmdldCA9ICQodGhpcyk7XHJcblxyXG4gICAgICAgIGxldCAkZHJvcERvd25NZW51ID0gJHRhcmdldC5maW5kKCcuZHJvcGRvd24tbWVudScpO1xyXG5cclxuICAgICAgICAvLyBQdXQgdGhlIGRyb3Bkb3duIG1lbnUgYWJvdmUgdGhlIGNsaWNrZWQgdGFyZ2V0LFxyXG4gICAgICAgIC8vIGlmIHRoZSBtZW51IHdvdWxkIHRvdWNoIG9yIGV2ZW4gYmUgbGFyZ2VyIHRoYW4gdGhlIGluZm8gcm93IGluIHRoZSBtYWluIGZvb3Rlci5cclxuICAgICAgICBpZiAoX2lzRHJvcERvd25PdXRPZlZlcnRpY2FsVmlldygkZHJvcERvd25NZW51KSkge1xyXG4gICAgICAgICAgICAkdGFyZ2V0LmFkZENsYXNzKCdkcm9wdXAnKTtcclxuICAgICAgICAgICAgJHRhcmdldC5yZW1vdmVDbGFzcygnZHJvcGRvd24nKTtcclxuICAgICAgICAgICAgJHRhcmdldC5maW5kKCcuY2FyZXQnKS5hZGRDbGFzcygnY2FyZXQtcmV2ZXJzZWQnKTtcclxuICAgICAgICB9IGVsc2UgaWYgKCR0YXJnZXQuaGFzQ2xhc3MoJ2Ryb3B1cCcpKSB7XHJcbiAgICAgICAgICAgICR0YXJnZXQucmVtb3ZlQ2xhc3MoJ2Ryb3B1cCcpO1xyXG4gICAgICAgICAgICAkdGFyZ2V0LmFkZENsYXNzKCdkcm9wZG93bicpO1xyXG4gICAgICAgICAgICAkdGFyZ2V0LmZpbmQoJy5jYXJldCcpLnJlbW92ZUNsYXNzKCdjYXJldC1yZXZlcnNlZCcpO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKF9pc0Ryb3BEb3duT3V0T2ZIb3Jpem9udGFsVmlldygkZHJvcERvd25NZW51KSkge1xyXG4gICAgICAgICAgICAkZHJvcERvd25NZW51LmFkZENsYXNzKCdkcm9wZG93bi1tZW51LXJpZ2h0Jyk7XHJcbiAgICAgICAgfSBlbHNlIGlmICgkdGFyZ2V0Lmhhc0NsYXNzKCdkcm9wZG93bi1tZW51LXJpZ2h0JykpIHtcclxuICAgICAgICAgICAgJHRhcmdldC5yZW1vdmVDbGFzcygnZHJvcGRvd24tbWVudS1yaWdodCcpO1xyXG4gICAgICAgIH1cclxuICAgIH1cclxuXHJcbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuICAgIC8vIElOSVRJQUxJWkFUSU9OXHJcbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuXHJcbiAgICBtb2R1bGUuaW5pdCA9IGZ1bmN0aW9uIChkb25lKSB7XHJcbiAgICAgICAgJCgnYm9keScpLm9uKCdzaG93LmJzLmRyb3Bkb3duJywgJy5idG4tZ3JvdXAuZHJvcGRvd24sIC5idG4tZ3JvdXAuZHJvcHVwJywgX2FkanVzdERyb3BEb3duUG9zaXRpb24pO1xyXG5cclxuICAgICAgICBkb25lKCk7XHJcbiAgICB9O1xyXG5cclxuICAgIHJldHVybiBtb2R1bGU7XHJcbn0pO1xyXG4iXX0=
